# Migration

You must have the latest version 9.9.2 to successfully run the migration process.

## Migration phases

- Stop your current deployment
- Amend the compose yaml and .env files
- Run the migration container by docker-compose
- Restart your deployment

## Modifications in docker-compose.yml file

### Add new environment variables to docker-compose file

**RM-JUPYTERHUB-DB**

Make sure you change these values only for the *rm-jupyterhub-db-svc* container.

Modify environment variable names:

from:

>     - POSTGRES_DB=${SERVER_DBSCHEMA}
>     - POSTGRES_USER=${SERVER_DBUSER}
>     - POSTGRES_PASSWORD=${SERVER_DBPASS}

to:

>     - POSTGRESQL_DATABASE=${SERVER_DBSCHEMA}
>     - POSTGRESQL_USER=${SERVER_DBUSER}
>     - POSTGRESQL_PASSWORD=${SERVER_DBPASS}

**RM-PROXY**
> UNPRIVILEGED_PORTS=${UNPRIVILEGED_PORTS}
---
<br />

**RM-INIT**
> DEBUG=false
---
<br />
Modify volume mapping 

from:
> .env:/.env
>
> keycloak-admin-cli-vol:/root/.keycloak/

to:

> .env:/rapidminer/.env
>
> keycloak-admin-cli-vol:/rapidminer/.keycloak/
---
<br />

**RTS-AGENT**
> SCORING_AGENT_ENABLESERVERLICENSE=${SCORING_AGENT_ENABLESERVERLICENSE}
>
> DEBUG=false

Modify license volume mapping from:
> rts-licenses-vol:/rapidminer-scoring-agent/home/resources/licenses/rapidminer-scoring-agent/

to
> rts-licenses-vol:/rapidminer-scoring-agent/home/resources/licenses
---
<br />

**CES**
> PA_BACKEND=${PA_BACKEND}
---
<br />

## Modifications in .env file

- Use -gen2 suffix for all xxx_VERSION, except: TabGo and DDM

Example:

> SERVER_VERSION=9.9.2-gen2

---
<br/>

- Change the image registry to staging

> REGISTRY=rapidminerstaging/

---
<br/>

Modify or add these lines:

**RTS-AGENT**
  > SCORING_AGENT_ENABLESERVERLICENSE=false

**Landing Page**
  > LANDING_BACKEND=http://landing-page:1080

**Tokentool**
  > TOKEN_BACKEND=http://rm-token-tool-svc:1080

**Lets Encrypt**
  > LE_BACKEND=http://letsencrypt-svc:1084

**RM-Proxy**
  > UNPRIVILEGED_PORTS=false

**Grafana**
  > \# Single value or comma separated list
  > >RTSA_DEPLOYMENTS=http://rts-agent-svc:8090/
  >
  > \# Possible values: NOTSET, DEBUG, INFO, WARNING, ERROR, CRITICAL
  > >GRAFANA_PROXY_LOGGING_LEVEL=INFO
  >
  > \# Set this to 'True' to log data (eg. result from webservice) returned from GF proxy
  > >GRAFANA_PROXY_LOG_RESPONSE_DATA=False

## Run migration

Copy the migration-compose.yaml next to your docker-compose.yml, so they will use the same .env file.

```bash
docker-compose -f migration-compose.yaml up
```

You should see no warnings nor errors. If you see any, check if the migration-compose.yaml can acces the same .env file as your deployment's docker-compose.yml.

## Start gen2 deployment

```bash
# download gen2 images
docker-compose pull
# run gen2 deployment
docker-compose up -d
```
