#!/bin/bash

# The old files correspond to version 9.9.2 of RapidMiner AI Hub
# The new files correspond to version 9.10.0 of RapidMiner AI Hub

old_yml_file="docker-compose.yml"
new_yml_file="docker-compose-gen2.yml"

old_env_file=".env"
new_env_file="env-gen2"

# Find values of the environment variables in the old files that differ from the new files
# and copy them to the new files, excluding variables that should have new values,
# such as those labelled VERSION / BACKEND / REGISTRY

diff -u $old_env_file $new_env_file | grep ^-[^#-] | grep -v VERSION | grep -v BACKEND | grep -v REGISTRY | cut -c 2- | cut -d= -f1 | \
	while read key; do
		if grep -q $key= $new_env_file; then
			replacement=$(grep ^${key}= $old_env_file | cut -d= -f2)
			echo "$key=$replacement"
			perl -pi -e "s@^$key=.*@$key=$replacement@" $new_env_file
		fi 
	done

# Create patch files

diff -u $old_env_file $new_env_file > upgrade-env.patch

diff -u $old_yml_file $new_yml_file > upgrade-yml.patch

